"use client"

import { Column, type ColumnDef } from "@tanstack/react-table"
import { TransformedStatewideService } from "../type/transformers"
import { Button } from "@/components/ui/button"
import { CaretDownIcon, CaretSortIcon, CaretUpIcon } from "@radix-ui/react-icons"
import { ComponentWithClassNameAndChildren } from "@/types/utils"
import { cn } from "@/lib/utils"
import { WorkflowButtonDelete } from "./workflow.button-delete"
import { WorkflowButtonView } from "./workflow.button-view"
import { WorkflowButtonUpdate } from "./workflow.button-update"

export const columns: ColumnDef<TransformedStatewideService>[] = [
  {
    accessorKey: "agencyId",
    accessorFn: (v) => v.agencyId,
    header: ({ column }) => {
      return (
        <INTERNAL__SortingColumnHeader column={column}>
          Agency Name
        </INTERNAL__SortingColumnHeader>
      )
    }
  },
  {
    accessorKey: "alias",
    header: "Service Name",
  },
  {
    accessorKey: "phone",
    header: "Phone",
  },
  {
    accessorKey: "url",
    header: "Website",
  },
  {
    accessorKey: "message",
    header: "Trip Details",
  },
  {
    accessorKey: "Actions",
    accessorFn: (value) => value,
    header: () => {
      return 'Actions'
    },
    cell: ({ cell }) => {
      const value = cell.getValue<TransformedStatewideService>()

      return (
        <div className="flex flex-row gap-2 justify-end">
          <div className="inline-flex -space-x-px rounded-lg shadow-sm shadow-black/5 rtl:space-x-reverse">
            <WorkflowButtonView
              data={value}
              className="rounded-none shadow-none first:rounded-s-lg last:rounded-e-lg focus-visible:z-10"
            />
            <WorkflowButtonUpdate
              data={value}
              className="rounded-none shadow-none first:rounded-s-lg last:rounded-e-lg focus-visible:z-10"
            />
            <WorkflowButtonDelete
              data={value}
              className="rounded-none shadow-none first:rounded-s-lg last:rounded-e-lg focus-visible:z-10"
            />
          </div>

          {/* <Popover> */}
          {/*   <PopoverTrigger asChild> */}
          {/*     <Button */}
          {/*       variant={"ghost"} */}
          {/*       size={"icon"} */}
          {/*       onClick={() => { */}
          {/*         console.log("context", cell.getValue()) */}
          {/**/}
          {/*       }}> */}
          {/*       <InfoIcon className="size-3.5" /> */}
          {/*     </Button> */}
          {/*   </PopoverTrigger> */}
          {/**/}
          {/*   <PopoverContent className="w-[64rem]">{value.message}</PopoverContent> */}
          {/* </Popover> */}
        </div>
      )
    },
  },
]

function INTERNAL__SortingColumnHeader({
  column,
  className,
  children,
}: ComponentWithClassNameAndChildren<{
  column: Column<TransformedStatewideService>
}>) {

  return (
    <Button
      size={"sm"}
      variant={"ghost"}
      className={cn("my-0.5", className)}
      onClick={() => column.toggleSorting(column.getIsSorted() === "asc")
      }
    >
      {children}

      <INTERNAL__ColumnSortingIcon column={column} />
    </Button>
  )
}

function INTERNAL__ColumnSortingIcon({
  column
}: {
  column: Column<TransformedStatewideService>
}) {
  const sorted = column.getIsSorted()
  if (sorted === 'asc') {
    return <CaretUpIcon className="ml-2 size-4" />
  }

  if (sorted === 'desc') {
    return <CaretDownIcon className="ml-2 size-4" />
  }

  return <CaretSortIcon className="ml-2 size-4" />
}

